
/*
 * DS_DCC.h
 *
 * Created: 2014/02/28 5:54:29
 *  Author: Yaasan
 */ 


#ifndef DS_DCC_H_
#define DS_DCC_H_


//#define TIME_DCC_0A 123 /* こちらは長くても問題なし */
//#define TIME_DCC_0B 126 /* こちらは長くても問題なし */
//#define TIME_DCC_1A 54//57.2 /* 58us - 2.6us(Deadtime) */
//#define TIME_DCC_1B 59 /* 58us - 2.6us(Deadtime) */
//#define TIME_DCC_0A 100 /* こちらは長くても問題なし */
//#define TIME_DCC_0B 100 /* こちらは長くても問題なし */
//#define TIME_DCC_1A 57 /* 58us - 2.6us(Deadtime) */
//#define TIME_DCC_1B 55 /* 58us - 2.6us(Deadtime) */

#define TIME_DCC_0AX 210 /* 10Xus, こちらは長くても問題なし */
#define TIME_DCC_0BX 210 /* 10Xus, こちらは長くても問題なし */
#define TIME_DCC_1AX 110 /* 58us - 2.6us(Deadtime) */
#define TIME_DCC_1BX 110 /* 58us - 2.6us(Deadtime) */

#define DCCPREAMBLE_DEFAULT		16		/**< 通常パケット用 */
#define DCCPREAMBLE_CV			28		/**< CVパケット用 */

void DCC_Init();

void DCC_SendInitialPacket(UC inPreambleCnt);
void DCC_SendPackets(UC* inPackets, UC inLen);
void DCC_SendPacketsEx(UC *inPackets, UC inLen, UC inPreambleCnt);
void DCC_SendPreamble(UC inSize);
void DCC_SendByte(UC inData);
void DCC_SendBit(UC inBit);

UC DCC_decodeSpeedStep28(short speed, UC direction);
UC DCC_decodeSpeedStep127(short speed, UC direction);
UC DCC_decodeSpeedStep14(short speed, UC direction, UC aFunction);
UC DCC_decodeFunction(UC function, UC power, UL *inFuncBuf);
UC DCC_decodeFunctionRaw(UC function, UL *inFuncBuf);

#endif /* DS_DCC_H_ */