/*
  OzOLED.cpp - 0.96' I2C 128x64 OLED Driver Library
  2014 Copyright (c) OscarLiang.net  All right reserved.
 
  Author: Oscar Liang
  
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

*/

// modify fot SPItransfer 2018/02/02 by twaydcc
#include "OzOLED_spi.h"

#ifdef MODESPI
#include <SPI.h>
#else
#include <Wire.h>
#endif

#include <avr/pgmspace.h>

// Uncomment this block to use hardware SPI
#define OLED_DC   6
#define OLED_CS   7
#define OLED_RST  8


#define FONT_WIDTH 7

// 8x8 Font ASCII 32 - 127 Implemented
// Users can modify this to support more characters(glyphs)
// BasicFont is placed in code memory.

// This font be freely used without any restriction(It is placed in public domain)
const byte BasicFont[][8] PROGMEM = {
	{0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},
	{0x00,0x00,0x5F,0x00,0x00,0x00,0x00,0x00},
	{0x00,0x00,0x07,0x00,0x07,0x00,0x00,0x00},
	{0x00,0x14,0x7F,0x14,0x7F,0x14,0x00,0x00},
	{0x00,0x24,0x2A,0x7F,0x2A,0x12,0x00,0x00},
	{0x00,0x23,0x13,0x08,0x64,0x62,0x00,0x00},
	{0x00,0x36,0x49,0x55,0x22,0x50,0x00,0x00},
	{0x00,0x00,0x05,0x03,0x00,0x00,0x00,0x00},
	{0x00,0x1C,0x22,0x41,0x00,0x00,0x00,0x00},
	{0x00,0x41,0x22,0x1C,0x00,0x00,0x00,0x00},
	{0x00,0x08,0x2A,0x1C,0x2A,0x08,0x00,0x00},
	{0x00,0x08,0x08,0x3E,0x08,0x08,0x00,0x00},
	{0x00,0xA0,0x60,0x00,0x00,0x00,0x00,0x00},
	{0x00,0x08,0x08,0x08,0x08,0x08,0x00,0x00},
	{0x00,0x60,0x60,0x00,0x00,0x00,0x00,0x00},
	{0x00,0x20,0x10,0x08,0x04,0x02,0x00,0x00},
	{0x00,0x3E,0x51,0x49,0x45,0x3E,0x00,0x00},
	{0x00,0x00,0x42,0x7F,0x40,0x00,0x00,0x00},
	{0x00,0x62,0x51,0x49,0x49,0x46,0x00,0x00},
	{0x00,0x22,0x41,0x49,0x49,0x36,0x00,0x00},
	{0x00,0x18,0x14,0x12,0x7F,0x10,0x00,0x00},
	{0x00,0x27,0x45,0x45,0x45,0x39,0x00,0x00},
	{0x00,0x3C,0x4A,0x49,0x49,0x30,0x00,0x00},
	{0x00,0x01,0x71,0x09,0x05,0x03,0x00,0x00},
	{0x00,0x36,0x49,0x49,0x49,0x36,0x00,0x00},
	{0x00,0x06,0x49,0x49,0x29,0x1E,0x00,0x00},
	{0x00,0x00,0x36,0x36,0x00,0x00,0x00,0x00},
	{0x00,0x00,0xAC,0x6C,0x00,0x00,0x00,0x00},
	{0x00,0x08,0x14,0x22,0x41,0x00,0x00,0x00},
	{0x00,0x14,0x14,0x14,0x14,0x14,0x00,0x00},
	{0x00,0x41,0x22,0x14,0x08,0x00,0x00,0x00},
	{0x00,0x02,0x01,0x51,0x09,0x06,0x00,0x00},
	{0x00,0x32,0x49,0x79,0x41,0x3E,0x00,0x00},
	{0x00,0x7E,0x09,0x09,0x09,0x7E,0x00,0x00},
	{0x00,0x7F,0x49,0x49,0x49,0x36,0x00,0x00},
	{0x00,0x3E,0x41,0x41,0x41,0x22,0x00,0x00},
	{0x00,0x7F,0x41,0x41,0x22,0x1C,0x00,0x00},
	{0x00,0x7F,0x49,0x49,0x49,0x41,0x00,0x00},
	{0x00,0x7F,0x09,0x09,0x09,0x01,0x00,0x00},
	{0x00,0x3E,0x41,0x41,0x51,0x72,0x00,0x00},
	{0x00,0x7F,0x08,0x08,0x08,0x7F,0x00,0x00},
	{0x00,0x41,0x7F,0x41,0x00,0x00,0x00,0x00},
	{0x00,0x20,0x40,0x41,0x3F,0x01,0x00,0x00},
	{0x00,0x7F,0x08,0x14,0x22,0x41,0x00,0x00},
	{0x00,0x7F,0x40,0x40,0x40,0x40,0x00,0x00},
	{0x00,0x7F,0x02,0x0C,0x02,0x7F,0x00,0x00},
	{0x00,0x7F,0x04,0x08,0x10,0x7F,0x00,0x00},
	{0x00,0x3E,0x41,0x41,0x41,0x3E,0x00,0x00},
	{0x00,0x7F,0x09,0x09,0x09,0x06,0x00,0x00},
	{0x00,0x3E,0x41,0x51,0x21,0x5E,0x00,0x00},
	{0x00,0x7F,0x09,0x19,0x29,0x46,0x00,0x00},
	{0x00,0x26,0x49,0x49,0x49,0x32,0x00,0x00},
	{0x00,0x01,0x01,0x7F,0x01,0x01,0x00,0x00},
	{0x00,0x3F,0x40,0x40,0x40,0x3F,0x00,0x00},
	{0x00,0x1F,0x20,0x40,0x20,0x1F,0x00,0x00},
	{0x00,0x3F,0x40,0x38,0x40,0x3F,0x00,0x00},
	{0x00,0x63,0x14,0x08,0x14,0x63,0x00,0x00},
	{0x00,0x03,0x04,0x78,0x04,0x03,0x00,0x00},
	{0x00,0x61,0x51,0x49,0x45,0x43,0x00,0x00},
	{0x00,0x7F,0x41,0x41,0x00,0x00,0x00,0x00},
	{0x00,0x02,0x04,0x08,0x10,0x20,0x00,0x00},
	{0x00,0x41,0x41,0x7F,0x00,0x00,0x00,0x00},
	{0x00,0x04,0x02,0x01,0x02,0x04,0x00,0x00},
	{0x00,0x80,0x80,0x80,0x80,0x80,0x00,0x00},
	{0x00,0x01,0x02,0x04,0x00,0x00,0x00,0x00},
	{0x00,0x20,0x54,0x54,0x54,0x78,0x00,0x00},
	{0x00,0x7F,0x48,0x44,0x44,0x38,0x00,0x00},
	{0x00,0x38,0x44,0x44,0x28,0x00,0x00,0x00},
	{0x00,0x38,0x44,0x44,0x48,0x7F,0x00,0x00},
	{0x00,0x38,0x54,0x54,0x54,0x18,0x00,0x00},
	{0x00,0x08,0x7E,0x09,0x02,0x00,0x00,0x00},
	{0x00,0x18,0xA4,0xA4,0xA4,0x7C,0x00,0x00},
	{0x00,0x7F,0x08,0x04,0x04,0x78,0x00,0x00},
	{0x00,0x00,0x7D,0x00,0x00,0x00,0x00,0x00},
	{0x00,0x80,0x84,0x7D,0x00,0x00,0x00,0x00},
	{0x00,0x7F,0x10,0x28,0x44,0x00,0x00,0x00},
	{0x00,0x41,0x7F,0x40,0x00,0x00,0x00,0x00},
	{0x00,0x7C,0x04,0x18,0x04,0x78,0x00,0x00},
	{0x00,0x7C,0x08,0x04,0x7C,0x00,0x00,0x00},
	{0x00,0x38,0x44,0x44,0x38,0x00,0x00,0x00},
	{0x00,0xFC,0x24,0x24,0x18,0x00,0x00,0x00},
	{0x00,0x18,0x24,0x24,0xFC,0x00,0x00,0x00},
	{0x00,0x00,0x7C,0x08,0x04,0x00,0x00,0x00},
	{0x00,0x48,0x54,0x54,0x24,0x00,0x00,0x00},
	{0x00,0x04,0x7F,0x44,0x00,0x00,0x00,0x00},
	{0x00,0x3C,0x40,0x40,0x7C,0x00,0x00,0x00},
	{0x00,0x1C,0x20,0x40,0x20,0x1C,0x00,0x00},
	{0x00,0x3C,0x40,0x30,0x40,0x3C,0x00,0x00},
	{0x00,0x44,0x28,0x10,0x28,0x44,0x00,0x00},
	{0x00,0x1C,0xA0,0xA0,0x7C,0x00,0x00,0x00},
	{0x00,0x44,0x64,0x54,0x4C,0x44,0x00,0x00},
	{0x00,0x08,0x36,0x41,0x00,0x00,0x00,0x00},
	{0x00,0x00,0x7F,0x00,0x00,0x00,0x00,0x00},
	{0x00,0x41,0x36,0x08,0x00,0x00,0x00,0x00},
	{0x00,0x02,0x01,0x01,0x02,0x01,0x00,0x00},
	{0x00,0x02,0x05,0x05,0x02,0x00,0x00,0x00} 
};


// Big numbers font, from 0 to 9 - 96 bytes each.
const byte bigNumbers2 [][16] PROGMEM = {
	
	//0
	{
		0b00001111, 0b11110000,
		0b00111111, 0b11111100,
		0b01111000, 0b00011110,
		0b01110000, 0b00001110,
		0b01111000, 0b00011110,
		0b00111111, 0b11111100,
		0b00001111, 0b11110000,
		0b00000000, 0b00000000
	},
	
	//1
	{
		0b00000000, 0b00000000,
		0b00000000, 0b00000000,
		0b00000000, 0b01110000,
		0b00000000, 0b00111100,
		0b01111111, 0b11111110,
		0b01111111, 0b11111110,
		0b00000000, 0b00000000,
		0b00000000, 0b00000000
	},
	
	//2
	{
		0b01000000, 0b00001100,
		0b01100000, 0b00001110,
		0b01111000, 0b00001110,
		0b01111111, 0b00001110,
		0b01110111, 0b11111100,
		0b01110000, 0b11111000,
		0b01100000, 0b00000000,
		0b00000000, 0b00000000
	},
	
	//3
	{
		0b01110000, 0b00000110,
		0b01110000, 0b00000110,
		0b01100001, 0b10000110,
		0b01100001, 0b10000110,
		0b01110011, 0b11001110,
		0b00111111, 0b11111100,
		0b00011111, 0b01111000,
		0b00000000, 0b00000000
	},
	
	//4
	{
		0b00011110, 0b00000000,
		0b00011111, 0b10000000,
		0b00011101, 0b11110000,
		0b00011100, 0b00001100,
		0b01111111, 0b11111110,
		0b01111111, 0b11111110,
		0b00011100, 0b00000000,
		0b00000100, 0b00000000
	},
	
	//5
	{
		0b00000000, 0b00000000,
		0b01110000, 0b01110000,
		0b01110000, 0b01111110,
		0b01110000, 0b01111110,
		0b01111000, 0b11101110,
		0b00111111, 0b11101110,
		0b00011111, 0b10001110,
		0b00000000, 0b00000000
	},
	
	//6
	{
		0b00011111, 0b10000000,
		0b00111111, 0b11100000,
		0b01110001, 0b11111000,
		0b01110001, 0b11111110,
		0b01110001, 0b11011110,
		0b00111111, 0b10000110,
		0b00011111, 0b00000000,
		0b00000000, 0b00000000
	},
	
	//7
	{
		0b00000010, 0b00001100,
		0b00000011, 0b00001110,
		0b00000001, 0b00000110,
		0b01111111, 0b10000110,
		0b00111111, 0b11110110,
		0b00000001, 0b11111110,
		0b00000000, 0b01001110,
		0b00000000, 0b00000000
	},
	
	//8
	{
		0b00111111, 0b01111100,
		0b01111111, 0b11111110,
		0b01100001, 0b10000110,
		0b01100001, 0b10000110,
		0b01100001, 0b10000110,
		0b01111111, 0b11111110,
		0b00111111, 0b01111100,
		0b00000000, 0b00000000
	},
	
	//9
	{
		0b00000001, 0b11111000,
		0b01100011, 0b11111100,
		0b01110011, 0b00001110,
		0b01111011, 0b00000110,
		0b00111111, 0b00001110,
		0b00001111, 0b11111100,
		0b00000011, 0b11111000,
		0b00000000, 0b00000000
	}
	
};


/* POWER SWITCH */
const byte iconThunder [] PROGMEM = {
	0b00111100,
	0b01000010,
	0b10000000,
	0b10011111,
	0b10011111,
	0b10000000,
	0b01000010,
	0b00111100
};

const byte iconRight [] PROGMEM = {
	0b00111100,
	0b00111100,
	0b00111100,
	0b00111100,
	0b11111111,
	0b01111110,
	0b00111100,
	0b00011000
};

const byte iconLeft [] PROGMEM = {
	0b00011000,
	0b00111100,
	0b01111110,
	0b11111111,
	0b00111100,
	0b00111100,
	0b00111100,
	0b00111100
};

const byte iconErr [] PROGMEM = {
	0b00000000,
	0b01000010,
	0b00100100,
	0b00011000,
	0b00011000,
	0b00100100,
	0b01000010,
	0b00000000
};

const byte iconErr2 [] PROGMEM = {
	0b11111111,
	0b10000001,
	0b10011001,
	0b10100101,
	0b10100101,
	0b10011001,
	0b10000001,
	0b11111111
};

const byte iconSquare2 [] PROGMEM = {
	0b01111110,
	0b11111111,
	0b11111111,
	0b11111111,
	0b11111111,
	0b11111111,
	0b11111111,
	0b01111110
};

const byte iconOff[] PROGMEM = {
	0b00111000,
	0b01000100,
	0b00111000,
	0b00000000,
	0b01111100,
	0b00010100,
	0b01111100,
	0b00010100
};

const byte iconHome [] PROGMEM = {
	0b00000000,
	0b01111100,
	0b01000110,
	0b01010111,
	0b01010111,
	0b01000110,
	0b01111100,
	0b00000000
};

// added by twaydcc at Dec.19 '18
const byte iconUp [] PROGMEM = {
	0b01100000,
	0b01111000,
	0b01111110,
	0b01111110,
	0b01111000,
	0b01100000,
	0b00000000,
	0b00000000
};

const byte iconDown [] PROGMEM = {
	0b00000110,
	0b00011110,
	0b01111110,
	0b01111110,
	0b00011110,
	0b00000110,
	0b00000000,
	0b00000000
};


const byte iconFwd [] PROGMEM = {
	0b00000000,
	0b01111111,
	0b01111111,
	0b00011100,
	0b00011100,
	0b00011100,
	0b00000000,
	0b00000000
};

const byte iconRev [] PROGMEM = {
	0b00000000,
	0b00011100,
	0b00011100,
	0b00011100,
	0b01111111,
	0b01111111,
	0b00000000,
	0b00000000
};

// ====================== LOW LEVEL =========================

void OzOLED::sendCommand(byte command){
#ifdef MODESPI
	//digitalWrite(cs, HIGH);
	digitalWrite(dc, LOW);
	//digitalWrite(cs, LOW);
	
	SPI.transfer(command);
	//_delay_us(1);
	//digitalWrite(cs, HIGH);
#else
	Wire.beginTransmission(OLED_ADDRESS); // begin transmitting
	Wire.write(OzOLED_COMMAND_MODE);//data mode
	Wire.write(command);
	Wire.endTransmission();    // stop transmitting
#endif
}


void OzOLED::sendData(byte data){
#ifdef MODESPI
	//digitalWrite(cs, HIGH);
	digitalWrite(dc, HIGH);
	//digitalWrite(cs, LOW);
	
	SPI.transfer(data);
	//_delay_us(1);
	//digitalWrite(cs, HIGH);
#else
	Wire.beginTransmission(OLED_ADDRESS); // begin transmitting
	Wire.write(OzOLED_DATA_MODE);//data mode
	Wire.write(data);
	Wire.endTransmission();    // stop transmitting
#endif
}

void OzOLED::drawBigNumber(byte X, byte Y, byte No)
{
	digitalWrite(cs, LOW);
	
	if ( X < 128 )
		setCursorXY(X, Y);
	
    for(byte i = 0; i < 8; i++) {
	
		//read bytes from code memory
		sendData(pgm_read_byte(&bigNumbers2[No][(i << 1) + 1])); 
	}
	
	if ( X < 128 )
		setCursorXY(X, Y + 1);
	
    for(byte i = 0; i < 8; i++) {
	
		//read bytes from code memory
		sendData(pgm_read_byte(&bigNumbers2[No][i << 1])); 
	}
	
	digitalWrite(cs, HIGH);
}


void OzOLED::drawIcon(byte X, byte Y, byte No, boolean inNot)
{
	byte aData = 0;
	
	digitalWrite(cs, LOW);
	
	if ( X < 128 )
		setCursorXY(X, Y);
	
    for(byte i=0; i<FONT_WIDTH; i++) {
	
		//read bytes from code memory
		switch(No)
		{
		case 0:
			aData = 0x00; 
			break;
		case 1:
			aData = pgm_read_byte(&iconThunder[i]); 
			break;
		case 2:
			aData = pgm_read_byte(&iconRight[i]); 
			break;
		case 3:
			aData = pgm_read_byte(&iconLeft[i]); 
			break;
		case 4:
			aData = pgm_read_byte(&iconErr[i]); 
			break;
		case 5:
			aData = pgm_read_byte(&iconSquare2[i]); 
			break;
		case 6:
			aData = pgm_read_byte(&iconErr2[i]); 
			break;			
		case 7:
			aData = pgm_read_byte(&iconOff[i]); 
			break;			
		case 8:
			aData = pgm_read_byte(&iconHome[i]); 
			break;			
		// added by twaydcc at Dec.19 '18
		case 9:
			aData = pgm_read_byte(&iconUp[i]); 
			break;			
		case 10:
			aData = pgm_read_byte(&iconDown[i]); 
			break;			
		
		case 11:
			aData = pgm_read_byte(&iconFwd[i]);
			break;
		case 12:
			aData = pgm_read_byte(&iconRev[i]);
			break;
		}
    	
    	if( inNot == true)
    	{
    		sendData(0xFF - aData);
    		
    	}
    	else
    	{
    		sendData(aData);
    	}
    	
    	
	}	
	
	digitalWrite(cs, HIGH);
}

void OzOLED::drawSpeedBar(byte X, byte Y, byte inSpeed, boolean inNot, boolean inHalf)
{
	byte aData = 0;
	byte aIndex = 0;
	byte aSpeed = (byte)(sqrt(inSpeed) * 21 / sqrt(255));
	
	digitalWrite(cs, LOW);
	
	if ( X < 128 )
	{
		setCursorXY(X, Y);
	}
	
	for( byte j = 0; j < 3; j++)
	{
		for( byte i = 0; i < FONT_WIDTH; i++)
		{
			if( (aIndex == 0) || (aIndex == 20) || ( aIndex < aSpeed))
			{
				aData = 0b01111111; 
			}
			else
			{
				aData = 0b01000001; 
			}
			
	    	if( inNot == true)
	    	{
	    		sendData(0xFF - aData);
	    	}
	    	else
	    	{
	    		sendData(aData);
	    	}
	    	
			//aIndex = aIndex + FONT_WIDTH;
			aIndex++;
		}
	}
	
	digitalWrite(cs, HIGH);
}

void OzOLED::drawLineHorizonal(byte Y, byte data)
{
	byte aX = 0;
	byte aY = Y >> 3;
	byte aY_e = Y - (aY << 3);
	
	digitalWrite(cs, LOW);
    
    for(byte i=0; i<16; i++)
	{
		setCursorXY(aX, aY);
		
		for(byte j = 0; j < 8; j++)
		{
			sendData(1 << aY_e);
		}
		
		aX = aX + 1;
	}
	
	digitalWrite(cs, HIGH);
}

void OzOLED::printChar(char C, byte X, byte Y){

	if ( X < 128 )
		setCursorXY(X, Y);

	//Ignore unused ASCII characters. Modified the range to support multilingual characters.
    if(C < 32 || C > 127)
		C='*'; //star - indicate characters that can't be displayed

	
    for(byte i=0; i<FONT_WIDTH; i++) {
	
       //read bytes from code memory
       sendData(pgm_read_byte(&BasicFont[C-32][i])); //font array starts at 0, ASCII starts at 32. Hence the translation
	 
    }
    
}

void OzOLED::printCharNOT(char C, byte X, byte Y)
{
	digitalWrite(cs, LOW);
	
	if ( X < 128 )
		setCursorXY(X, Y);

	//Ignore unused ASCII characters. Modified the range to support multilingual characters.
    if(C < 32 || C > 127)
		C='*'; //star - indicate characters that can't be displayed

	
    for(byte i=0; i<FONT_WIDTH; i++) {
	
       //read bytes from code memory
    	sendData(0xFF & ~pgm_read_byte(&BasicFont[C-32][i])); //font array starts at 0, ASCII starts at 32. Hence the translation
	 
    }
    
	digitalWrite(cs, HIGH);
}

void OzOLED::printString(const char *String, byte X, byte Y, byte numChar){

	digitalWrite(cs, LOW);
	
	if ( X < 128 )
		setCursorXY(X, Y);
	byte count=0;
    while(String[count] && count<numChar){
		printChar(String[count++]);  
	}
	
	digitalWrite(cs, HIGH);
}

void OzOLED::printStringNOT(const char *String, byte X, byte Y, byte numChar)
{
	digitalWrite(cs, LOW);
	
	if ( X < 128 )
		setCursorXY(X, Y);
	
	byte count=0;
    while(String[count] && count<numChar){
		printCharNOT(String[count++]);  
	}
	
	digitalWrite(cs, HIGH);
}


byte OzOLED::printNumber(long long_num, byte X, byte Y){

	digitalWrite(cs, LOW);

	if ( X < 128 )
		setCursorXY(X, Y);

	byte char_buffer[10] = "";
	byte i = 0;
	byte f = 0; // number of characters

	if (long_num < 0) {
	
		f++;
		printChar('-');
		long_num = -long_num;
	
	} 
	else if (long_num == 0) {
	
		f++;
		printChar('0');
		digitalWrite(cs, HIGH);
		return f;
	
	} 

	while (long_num > 0) {
	
		char_buffer[i++] = long_num % 10;
		long_num /= 10;
	
	}

	f += i;
	for(; i > 0; i--) {

		printChar('0'+ char_buffer[i - 1]);

	}
	
	digitalWrite(cs, HIGH);
	return f;
}




byte OzOLED::printNumber(float float_num, byte prec, byte X, byte Y){

	digitalWrite(cs, LOW);

	if ( X < 128 )
		setCursorXY(X, Y);

// prec - 6 maximum

	byte num_int = 0;
	byte num_frac = 0;
	byte num_extra = 0;
	
	long d = float_num; // get the integer part
	float f = float_num - d; // get the fractional part
	
	
	if (d == 0 && f < 0.0){
	
		printChar('-');
		num_extra++;
		printChar('0');
		num_extra++;
		f *= -1;
		
	}
	else if (d < 0 && f < 0.0){
	
		num_int = printNumber(d); // count how many digits in integer part
		f *= -1;
		
	}
	else{
	
		num_int = printNumber(d); // count how many digits in integer part
	
	}
	
	// only when fractional part > 0, we show decimal point
	if (f > 0.0){
	
		printChar('.');
		num_extra++;
	
		long f_shift = 1;
		
		if (num_int + prec > 8) 
			prec = 8 - num_int;
		
		for (byte j=0; j<prec; j++){
			f_shift *= 10;
		}

		num_frac = printNumber((long)(f*f_shift)); // count how many digits in fractional part
		
	}
	
	digitalWrite(cs, HIGH);
    
	return num_int + num_frac + num_extra;
}



void OzOLED::printBigNumber(const char *number, byte X, byte Y, byte numChar){
// big number pixels: 8 x 16
	
	byte aX = X;
	byte column = 0;
	byte count = 0;

	digitalWrite(cs, LOW);
	
	while(number[count] && count<numChar)
	{
		
		if(number[count] == 0x20)
		{
			drawIcon(aX, Y, 0, false);
			drawIcon(aX, Y + 1, 0, false);
			
		}
		else
		{
			drawBigNumber(aX, Y, number[count] - '0');
		}
		
		count++;
		
		aX = aX + 1;
	}
	
	digitalWrite(cs, HIGH);
}


void OzOLED::drawBitmap(const byte *bitmaparray, byte X, byte Y, byte width, byte height){

// max width = 16
// max height = 8

	digitalWrite(cs, LOW);

	setCursorXY( X, Y );
	
	byte column = 0; 
	for(int i=0; i<width*8*height; i++) {  

		sendData(pgm_read_byte(&bitmaparray[i]));
		
		if(++column == width*8) {
			column = 0;
			setCursorXY( X, ++Y );
		} 
	}
	
	digitalWrite(cs, HIGH);
}

void OzOLED::drawBitmap2(const byte *bitmaparray, byte X, byte Y, byte width, byte height)
{
	byte aX = X, aY = Y;
	
	digitalWrite(cs, LOW);
	
	setCursorXY( aX, aY );
	
	byte column = 0;
	
	for(int i = 0; i < width * height; i++)
	{  
		
		sendData(pgm_read_byte(&bitmaparray[i]));
		
		if(column == width)
		{
			column = 0;
			aY++;
			//setCursorXY( aX, aY);
		}
		else
		{
			column++;
		}
	}

	digitalWrite(cs, HIGH);
}



// =================== High Level ===========================

OzOLED::OzOLED(){
}

OzOLED::OzOLED(int8_t DC, int8_t RST, int8_t CS)
{
  dc = DC;
  rst = RST;
  cs = CS;
}

void OzOLED::init(){
	
#ifdef MODESPI
	pinMode(dc, OUTPUT);
	pinMode(cs, OUTPUT);
	pinMode(rst, OUTPUT);
	
	SPI.begin();
	SPI.beginTransaction(SPISettings(8000000, MSBFIRST, SPI_MODE0));
	
	digitalWrite(rst, HIGH);
	// VDD (3.3V) goes high at start, lets just chill for a ms
	delay(1);
	// bring reset low
	digitalWrite(rst, LOW);
	delay(10);
	// bring out of reset
	digitalWrite(rst, HIGH);
#else
	Wire.begin();
	
	// upgrade to 400KHz! (only use when your other i2c device support this speed)
	if (I2C_400KHZ){
		// save I2C bitrate (default 100Khz)
		byte twbrbackup = TWBR;
		TWBR = 12; 
		//TWBR = twbrbackup;
		//Serial.println(TWBR, DEC);
		//Serial.println(TWSR & 0x3, DEC);
	}
#endif
	
	digitalWrite(cs, LOW);
    setPowerOff(); 	//display off
	
   // Init sequence

   sendCommand(0xa1); //segment remap (column 127  is mapped to SEG0)
   sendCommand(0xda); //common pads hardware: alternative
   sendCommand(0x12);
   sendCommand(0xc8); //common output scan direction:com63~com0
   sendCommand(0xa8); //multiplex ration mode:63
   sendCommand(0x3f);

	//Charge pump ON
   sendCommand(0x8D);
   sendCommand(0x14);

	
    delay(10); 
    setPowerOn();	//display on
    delay(10); 
	
	//setInverseDisplay();
    setNormalDisplay();  //default Set Normal Display
	setPageMode();	// default addressing mode
	clearDisplay();
	setCursorXY(0,0);
	
	digitalWrite(cs, HIGH);

}

void OzOLED::setCursorXY(byte X, byte Y){
	// Y - 1 unit = 1 page (8 pixel rows)
	// X - 1 unit = 7 pixel columns

    sendCommand(0x00 + (FONT_WIDTH*X & 0x0F)); 		//set column lower address
    sendCommand(0x10 + ((FONT_WIDTH*X>>4)&0x0F)); 	//set column higher address
	sendCommand(0xB0 + Y); 					//set page address
	
}

void OzOLED::clearDisplay()
{

	digitalWrite(cs, LOW);

	for(byte page=0; page<8; page++) {	
	
		//setCursorXY(0, page);     
		for(byte column=0; column<128; column++){  //clear all columns
			setCursorXY(column, page);
			sendData(0);    
		}

	}
	
	setCursorXY(0,0);  
	
	digitalWrite(cs, HIGH);
}

void OzOLED::lcd_clear()
{
	clearDisplay();
}


/*
void OzOLED::clearPage(byte page)	{
	// clear page and set cursor at beginning of that page

	setCursorXY(0, page);    
	for(byte column=0; column<128; column++){  //clear all columns
		sendData(0x00);    
	}
	
}
*/


void OzOLED::setInverseDisplay(){

	sendCommand(OzOLED_CMD_INVERSE_DISPLAY);
	
}

void OzOLED::setNormalDisplay(){

	sendCommand(OzOLED_CMD_NORMAL_DISPLAY);
	
}

void OzOLED::setPowerOff(){

	sendCommand(OzOLED_CMD_DISPLAY_OFF);
	
}

void OzOLED::setPowerOn(){

	sendCommand(OzOLED_CMD_DISPLAY_ON);
	
}

void OzOLED::setBrightness(byte Brightness){

	digitalWrite(cs, LOW);

	sendCommand(OzOLED_CMD_SET_BRIGHTNESS);
	sendCommand(Brightness);
   
	digitalWrite(cs, HIGH);
}

void OzOLED::setPageMode(){
	digitalWrite(cs, LOW);
	
	addressingMode = PAGE_ADDRESSING;
	sendCommand(0x20); 				//set addressing mode
	sendCommand(PAGE_ADDRESSING); 	//set page addressing mode
	
	digitalWrite(cs, HIGH);
}

void OzOLED::setHorizontalMode(){
	digitalWrite(cs, LOW);
	
	addressingMode = HORIZONTAL_ADDRESSING;
	sendCommand(0x20); 				//set addressing mode
	sendCommand(HORIZONTAL_ADDRESSING); 	//set page addressing mode
	
	digitalWrite(cs, HIGH);
}


// startscrollright
// Activate a right handed scroll for rows start through stop
// Hint, the display is 16 rows tall. To scroll the whole display, run:
// scrollRight(0x00, 0x0F)  - start - stop
void OzOLED::scrollRight(byte start, byte end, byte speed){

	digitalWrite(cs, LOW);

    sendCommand(OzOLED_RIGHT_SCROLL);  //Horizontal Scroll Setup
    sendCommand(0x00);	// dummy byte 
    sendCommand(start);	// start page address
    sendCommand(speed);	// set time interval between each scroll
    sendCommand(end);	// end page address
	
    sendCommand(0x01);  
    sendCommand(0xFF);
	
    sendCommand(0x2f);  //active scrolling
	
	digitalWrite(cs, HIGH);
}


// startscrollleft
// Activate a right handed scroll for rows start through stop
// Hint, the display is 16 rows tall. To scroll the whole display, run:
// display.scrollright(0x00, 0x0F)   - start - stop
void OzOLED::scrollLeft(byte start, byte end, byte speed){

	digitalWrite(cs, LOW);
	
    sendCommand(OzOLED_LEFT_SCROLL);  //Horizontal Scroll Setup
    sendCommand(0x00);	// dummy byte
    sendCommand(start);	// start page address
    sendCommand(speed);	// set time interval between each scroll
    sendCommand(end);	// end page address
	
    sendCommand(0x01);  
    sendCommand(0xFF);  
	
    sendCommand(0x2f);  //active scrolling
	
	digitalWrite(cs, HIGH);
}

// startscrolldiagright
// Activate a diagonal scroll for rows start through stop
// Hint, the display is 16 rows tall. To scroll the whole display, run:
// display.scrollright(0x00, 0x0F) 
void OzOLED::scrollDiagRight(){
	
	digitalWrite(cs, LOW);

        sendCommand(OzOLED_SET_VERTICAL_SCROLL_AREA);        
        sendCommand(0X00);
        sendCommand(OzOLED_Max_Y);
        sendCommand(OzOLED_VERTICAL_RIGHT_SCROLL); //Vertical and Horizontal Scroll Setup
        sendCommand(0X00); 	//dummy byte
        sendCommand(0x00);	 //define page0 as startpage address
        sendCommand(0X00);	//set time interval between each scroll ste as 6 frames
        sendCommand(0x07);	//define page7 as endpage address
        sendCommand(0X01);	//set vertical scrolling offset as 1 row
        sendCommand(OzOLED_CMD_ACTIVATE_SCROLL); //active scrolling
	
	digitalWrite(cs, HIGH);
}

void OzOLED::scrollDiagLeft(){
	
	digitalWrite(cs, LOW);

        sendCommand(OzOLED_SET_VERTICAL_SCROLL_AREA);        
        sendCommand(0X00);
        sendCommand(OzOLED_Max_Y);
        sendCommand(OzOLED_VERTICAL_LEFT_SCROLL); //Vertical and Horizontal Scroll Setup
        sendCommand(0X00); //dummy byte
        sendCommand(0x00);	 //define page0 as startpage address
        sendCommand(0X00);	//set time interval between each scroll ste as 6 frames
        sendCommand(0x07);	//define page7 as endpage address
        sendCommand(0X01);	//set vertical scrolling offset as 1 row
        sendCommand(OzOLED_CMD_ACTIVATE_SCROLL); //active scrolling
	
	digitalWrite(cs, HIGH);
}


void OzOLED::setActivateScroll(byte direction, byte startPage, byte endPage, byte scrollSpeed){


/*
This function is still not complete, we need more testing also.
Use the following defines for 'direction' :

 Scroll_Left			
 Scroll_Right			

For Scroll_vericle, still need to debug more... 

Use the following defines for 'scrollSpeed' :

 Scroll_2Frames		
 Scroll_3Frames
 Scroll_4Frames
 Scroll_5Frames	
 Scroll_25Frames
 Scroll_64Frames
 Scroll_128Frames
 Scroll_256Frames

*/

	digitalWrite(cs, LOW);

	if(direction == Scroll_Right) {
	
		//Scroll Right
		sendCommand(0x26);
		
	}
	else {
	
		//Scroll Left  
		sendCommand(0x27);

	}
	/*
	else if (direction == Scroll_Up ){
	
		//Scroll Up  
		sendCommand(0x29);
	
	}
	else{
	
		//Scroll Down  
		sendCommand(0x2A);
	
	}
	*/
	sendCommand(0x00);//dummy byte
	sendCommand(startPage);
	sendCommand(scrollSpeed);	
	sendCommand(endPage);		// for verticle scrolling, use 0x29 as command, endPage should = start page = 0
	
	/*
	if(direction == Scroll_Up) {
	
		sendCommand(0x01);

	}
	*/

	sendCommand(OzOLED_CMD_ACTIVATE_SCROLL);

	digitalWrite(cs, HIGH);
}

void OzOLED::setDeactivateScroll(){

	digitalWrite(cs, LOW);
	
	sendCommand(OzOLED_CMD_DEACTIVATE_SCROLL);

	digitalWrite(cs, HIGH);
}




OzOLED OzOled;  // Preinstantiate Objects

