// Mr Watch DCC Monitor
// By yaasan
// Copyright(C) 2017- Desktop Station Co.,Ltd.
// Add Function by Henohenomoheji★ ver 1
// Add PitIn SSpeedMetor by TRAINO ★ Ver 2 
// Add 1/87,1/48 ★ Ver 2.1
// modify scale setting ★ Ver 2.2

#include "NmraDcc_v141.h"
#include <Wire.h>
#include "I2CLCDLib.h"
#include <EEPROM.h>

// definition,configuration
//#define DEBUG

#define PIN_DCCIN 2
// Additional pin asn for PitIn-S ★
// A2 Voltage detect
// A3 main button(RED)
// A1 dec button(BLE)
// D4 passing meter input
// D5 passing meter input
// D6 inc button(GRN)
// D7 clear passing speedmeter

#define DECODER_ADDRESS 3
#define MAX_LOCTABLE 16
#define MAX_ACCTABLE 128

#define MODE_LOC 0
#define MODE_ACC 1
#define MODE_VMON 2
#define MODE_ERR 3
#define MODE_TOTAL 4

#define PULSE_MIN	40
#define PULSE_MAX	200

#define PULSE_BUF_MAX 128

/* DCC SpeedStep 28専用テーブル */
const uint8_t DCC_28SPEEDMAP[29] = {
  0b00000, 0b00010, 0b10010, 0b00011,
  0b10011, 0b00100, 0b10100, 0b00101,
  0b10101, 0b00110, 0b10110, 0b00111,
  0b10111, 0b01000, 0b11000, 0b01001,
  0b11001, 0b01010, 0b11010, 0b01011,
  0b11011, 0b01100, 0b11100, 0b01101,
  0b11101, 0b01110, 0b11110, 0b01111, 0b11111
};

//使用クラスの宣言
NmraDcc	 Dcc;
DCC_MSG	 Packet;

/* LCD functions */
I2CLCDLib LCD;

//Task Schedule
unsigned long gPreviousL5 = 0;
unsigned long gPreviousL1 = 0;


struct LocData {
  uint16_t	mAddr;
  uint16_t  mSpeed;
  uint16_t  mSpeedhex;  // ★ for hexadecimal 
  uint8_t	mDirection;
  uint32_t	mFunction;
};

unsigned char message[10]; //　★ DCC message

LocData gLocTable[MAX_LOCTABLE];
uint16_t gAccTable[MAX_ACCTABLE];

uint16_t gAccLatestAddr[4] = {0, 0, 0, 0};
uint16_t gAccLatestDir[4] = {0, 0, 0, 0};
uint16_t gAccLastAddr = 9999;


uint8_t gMode = MODE_LOC;
uint8_t gTopIndex_Loc = 0xFF;
uint8_t gTopIndex_Acc = 0;

uint8_t gWatchMode = 0; // Analogを初期モードにする

uint8_t gButtonStatus = 0;

uint16_t gCount_Err = 0;
uint16_t gCount_Idle = 0;
uint16_t gCount_Reset = 0;
uint16_t gCount_PreMin = 255;
uint16_t gCount_PreMax = 0;


void(* resetFunc) (void) = 0;  //declare reset function at address 0
void OutputResults();
void ClearTable();
void DisplayFunctionBit(uint32_t inFunctionBits);
void DisplayAccBit(uint16_t inFunctionBits);
uint16_t ReadEdcVoltage();

void updateDccSpeed(word inLocoAddr, uint16_t inAddr, uint8_t inSpeed, uint8_t inDir, uint8_t inSpeedSteps );
// void decodeLocoPacket(uint8_t inPacket1, uint8_t inPacket2); unused
uint16_t getLocAddrIndex(uint16_t inAddr);

unsigned long checkTime, edgeTime, oldEdgeTime; /**********************************/
unsigned long scale; // ex 150
unsigned long edgeCount = 0;
char flag = 0;
char validInt1 = 0;
char dbuff[20];
#define UPDATEMS 1000
int speed = 0;

void edge() {   /* Edge detect for speedmeter*/
  validInt1 = 1;
  edgeTime = millis();
  edgeCount++;
  flag = 1;
}

void dispRollerSpeed() {
  if (1) {
    if (millis() > (checkTime + UPDATEMS)) {
      LCD.lcd_setCursor(0, 1);
      if (edgeCount != 0) {
        //speed = (1000000/35/scale/6*314/(edgeTime-oldEdgeTime)*edgeCount);
        // ==>> speed = scale * 0.006 * 3.14 * 3600  /(edgeTime-oldEdgeTime) * edgeCount
        speed =  edgeCount *  scale * 68 / (edgeTime - oldEdgeTime) ;
        sprintf(dbuff, "%3dkm/h ", speed);
        // sprintf(dbuff,"%3dkm/h ",(100000/35/15/6*314/(edgeTime-oldEdgeTime)*edgeCount));
        oldEdgeTime = edgeTime;
        LCD.lcd_printStr(dbuff);
        checkTime += UPDATEMS;
        edgeCount = 0;
      }
      else {  // slow speed less than one count
        if ((millis() - oldEdgeTime) > 4500) {
          speed = 0;
          sprintf(dbuff, "  0km/h ", 0);
        }
        else {
          // ???  sprintf(dbuff, "*%2dkm/h ", (100000 / 35 / 15 / 6 * 314 / (millis() - oldEdgeTime) * 1));
          speed =  1 *  scale * 34 / (millis() - oldEdgeTime) ; // 34 <= 68/2
          sprintf(dbuff, "*%2dkm/h ", speed); // Display with '*' 
        }
        LCD.lcd_printStr(dbuff);
        checkTime += UPDATEMS;
      }

    }
    if (speed == 0) validInt1 = 0;
  }
}
void setup()
{
  ClearTable();

  //Pin mode
  pinMode(A2, INPUT); //Edc
  pinMode(A3, INPUT); //Button
  
  
  // Additional setup for PitIn-S
  pinMode(A1, INPUT); //Button
  pinMode(6, INPUT); //Button
  pinMode(7, OUTPUT); // for reset passing speedmeter
  digitalWrite(A3, 1); //key pullup
  digitalWrite(A1, 1); //key pullup　
  digitalWrite(6, 1); //key pullup　
  digitalWrite(4, 1); //<important> stable input for passing meter　
  digitalWrite(5, 1); //stable input for passing meter　
  //digitalWrite(2, 1); //pullup INT0　
  digitalWrite(3, 1); //pullup INT1(check PitIn-S)　　

  pinMode(A0, OUTPUT);
  digitalWrite(A0, 0); //Reset High for display unit
  delay(50);
  digitalWrite(A0, 1); //Reset High for display unit
  delay(50);

  if (EEPROM.read( 0 ) == 255 ) EEPROM.write( 0, 1 ) ; // defaut gare = '1/150'
  if (EEPROM.read( 1 ) == 255 ) EEPROM.write( 1, 150 ) ; // defaut gare = '1/150'

  scale = EEPROM.read( 1 );

  /* LCD init */
  LCD.begin();

   
  // Configuration mode
  if (digitalRead(A3) == LOW) {
    
    LCD.lcd_setCursor(0, 0);
    LCD.lcd_printStr("PitIn-S ");
    LCD.lcd_setCursor(0, 1);
    LCD.lcd_printStr("byTRAINO");
    delay(3000);    
    LCD.lcd_setCursor(0, 1);
    LCD.lcd_printStr(" Ver 2.2"); // ★
    delay(3000);
    for (; digitalRead(A3) == LOW;); // wait release switch

    LCD.lcd_setCursor(0, 0);
    LCD.lcd_printStr("SelMode ");
    for (;;) {
      LCD.lcd_setCursor(0, 1);
      if(EEPROM.read(0)!=2)
        LCD.lcd_printStr("<DCC/AN>");  //1
      else
        LCD.lcd_printStr("<Analog>");  //2

      if (digitalRead(A3) == LOW) break;
      if (digitalRead(A1) == LOW) {EEPROM.write(0,1); delay(100);}
      if (digitalRead(6) == LOW)  {EEPROM.write(0,2); delay(100);}
    }

    for (; digitalRead(A3) == LOW;); // wait release switch
    
    LCD.lcd_setCursor(0, 0);
    LCD.lcd_printStr("SelScale");
    for (;;) {
      LCD.lcd_setCursor(0, 1);
      sprintf(message, "<1/%d>  ", scale);
      LCD.lcd_printStr(message);
      delay(100);

      if (digitalRead(A3) == LOW) {
        for (; digitalRead(A3) == LOW;);
        EEPROM.write(1, scale);
        break;
      }
      if (digitalRead(A1) == LOW) {
        for (; digitalRead(A1) == LOW;);
        switch (scale) { // ★ V2.2
          case 160: scale = 220; break;
          case 150: scale = 160; break;
          case 148: scale = 150; break;
          case 87: scale = 148; break;
          case 80: scale = 87; break;
          case 48: scale = 80; break;
          default: scale = 48; break; 
        }
      }
      if (digitalRead(6) == LOW) {
        for (; digitalRead(6) == LOW;);
        switch (scale) { // ★ V2.2
          case 80: scale = 48; break;
          case 87: scale = 80; break;
          case 148: scale = 87; break;
          case 150: scale = 148; break;
          case 160: scale = 150; break;
          case 220: scale = 160; break;
          default: scale = 220; break;        
        }
      }
    }

  }
  // End of conf.


  //シリアル通信開始
  Serial.begin(115200);

  Serial.println("--------------------------------------");
  Serial.println("Desktop Station Monitor               ");
  Serial.println("--------------------------------------");
  Serial.println("100 Ready");
  Serial.println("@DSG,999,");

 if(EEPROM.read(0)!=2) { 
    // Setup which External Interrupt, the Pin it's associated with that we're using, disable pullup.
    Dcc.pin(0, PIN_DCCIN, 0);
  
    // Call the main DCC Init function to enable the DCC Receiver
    Dcc.init( 140, 10, 0 , 0 );
 }
  //Reset task
  gPreviousL5 = millis();

  oldEdgeTime = millis(); // for passing speed meter
  attachInterrupt(1, edge, FALLING); // for passing speed meter


}

void loop()
{
  uint8_t aUpdate = 0;
  unsigned char btn = 0;

  // You MUST call the NmraDcc.process() method frequently from the Arduino loop() function for correct library operation
  Dcc.process();

  if ( (millis() - gPreviousL1) >= 100)
  {
    //Reset task ★処理の最初に変更
    gPreviousL1 = millis();

    uint8_t aButton = digitalRead(A3); if (aButton == 0) btn = 'R'; // save button status
    uint8_t bButton = digitalRead(A1); if (aButton == 0) btn = 'B';
    uint8_t cButton = digitalRead(6); if (aButton == 0) btn = 'G';


    //Update Button status
    if ( (gButtonStatus == 1) && (aButton == 0))
    {
      gMode++;
      aUpdate = 1;

    }

    gButtonStatus = aButton;

  }

  if ( ((millis() - gPreviousL5) >= 600) || (aUpdate == 1))

  {
    //Reset task
    gPreviousL5 = millis();

    //Main Task
    OutputResults();

    btn = 0;

  }


}

void passingSpeedMeter() {
  char aTexts[9];  // -> unsigned -> char  ★計算にも使うため
  unsigned long t1 = 0, t2 = 0,timeout = 0;

  for (; digitalRead(A3) == LOW;);
  // check expternal circuit
  digitalWrite(7, LOW); // Reset F.F.
  delay(10);
  if((digitalRead(4) == HIGH)&&(digitalRead(5) == HIGH)) {
    LCD.lcd_setCursor(0, 0);
    LCD.lcd_printStr("Invalid ");
    LCD.lcd_setCursor(0, 1);
    LCD.lcd_printStr("P-SpdMtr");
      delay(1000);    
        gMode++;  // show next Item
      return;
  }
  digitalWrite(7, HIGH); // Reset release

  LCD.lcd_setCursor(0, 0);
  LCD.lcd_printStr("P-SpdMtr");

  for (;;) {
    LCD.lcd_setCursor(0, 1);
    LCD.lcd_printStr(".Waiting");
    delay(1000);

    // wait off
    for (;;) {  // wait both sig.
      if((digitalRead(4) == LOW) || (digitalRead(5) == LOW))break;
      digitalWrite(7, LOW);
      delay(10);
      digitalWrite(7, HIGH);
      delay(10);
     if(digitalRead(A3) == LOW) {for (; digitalRead(A3) == LOW;);gMode++;return;}
    }

    t1 = 0; t2 = 0; timeout=0;
    // wait on
    for (; t1 * t2 == 0;) {  // wait both sig.
      if ((t1 == 0) && (digitalRead(4) == HIGH)) timeout = t1 = millis();
      if ((t2 == 0) && (digitalRead(5) == HIGH)) timeout = t2 = millis();
      if ((timeout!=0) && ( millis()> (timeout+10000) ))  {
          LCD.lcd_setCursor(0, 1);
          LCD.lcd_printStr(".timeout");
          delay(3000);
          return;
      }
      
      if(digitalRead(A3) == LOW) {for (; digitalRead(A3) == LOW;);gMode++;return;}
    }
    LCD.lcd_setCursor(0, 1);
    if (t1 > t2) {
      sprintf(aTexts, "T=%4dms", t1 - t2);
      LCD.lcd_printStr(aTexts);
      LCD.lcd_setCursor(0, 0);
      sprintf(aTexts, " %3ldkm/h", long(long(scale * 3600 * 81) / (t1 - t2) / 1000));
    }
    else {
      sprintf(aTexts, "T=%4dms", t2 - t1);
      LCD.lcd_printStr(aTexts);
      LCD.lcd_setCursor(0, 0);
      sprintf(aTexts, " %3ldkm/h", long(long(scale * 3600 * 81) / (t2 - t1) / 1000));
    }
    LCD.lcd_printStr(aTexts);

    // Wait end of train
    delay(500);
    if(digitalRead(A3) == LOW) {for (; digitalRead(A3) == LOW;);gMode++;return;}
    do {
      digitalWrite(7, LOW);
      delay(10);
      digitalWrite(7, HIGH);
      delay(500);
      if(digitalRead(A3) == LOW) {for (; digitalRead(A3) == LOW;);gMode++;return;}
    } while ((digitalRead(4) == HIGH) || (digitalRead(5) == HIGH));
    do {
      digitalWrite(7, LOW);
      delay(10);
      digitalWrite(7, HIGH);
      delay(500);
      if(digitalRead(A3) == LOW) {for (; digitalRead(A3) == LOW;);gMode++;return;}
    } while ((digitalRead(4) == HIGH) || (digitalRead(5) == HIGH));
    do {
      digitalWrite(7, LOW);
      delay(10);
      digitalWrite(7, HIGH);
      delay(500);
      if(digitalRead(A3) == LOW) {for (; digitalRead(A3) == LOW;);gMode++;return;}
    } while ((digitalRead(4) == HIGH) || (digitalRead(5) == HIGH));

  }

}




void OutputResults()
{
  char aTexts[9];  // -> unsigned  ★計算にも使うため
  uint16_t aVolt;
  uint16_t aLocAddr;
  uint16_t aMax0 = 0;
  uint16_t aMax1 = 0;
  uint16_t aMin0 = 0xFFFF;
  uint16_t aMin1 = 0xFFFF;

  if ( gWatchMode == 0 )
  {
    if ( (gMode %= 2) == 0 ) // ★add PWM duty indicator
    {
      LCD.lcd_setCursor(0, 0);
      aVolt = ReadEdcVoltage();
      int dutyA = 0 ;
      int dutyB = 0 ;
      for (char c = 0; c < 100; c++) { // get 100 times
        if ( digitalRead(2) != 0 ) dutyA++;
        if ( digitalRead(8) != 0 ) dutyB++;
        delay(1);
      }
      if (dutyB > dutyA) dutyA = dutyB; // ★ show bigger PWM data
      sprintf(aTexts, "%2d.%dV%2d%%   ", aVolt / 10, aVolt % 10, dutyA);

      LCD.lcd_printStr(aTexts);
      LCD.lcd_setCursor(0, 1);
      if (validInt1)
        dispRollerSpeed();
      else
        LCD.lcd_printStr("[Analog]");
      digitalWrite(7, LOW); delay(10); digitalWrite(7, HIGH); // assirt F.F. clear

    }
    else {
      passingSpeedMeter();
    }

  }
  else
  {


    switch ( gMode %= 8 ) //** 5=>6=>8
    {

      case 0: // ★Main Display

        if ( gTopIndex_Loc != 0xFF)
        {
          /* ロコが登録中の時 */
          aLocAddr = (gLocTable[gTopIndex_Loc].mAddr);
          sprintf(aTexts, "L%3d%s%2d%%", aLocAddr, gLocTable[gTopIndex_Loc].mDirection == 0 ? "R" : "F", gLocTable[gTopIndex_Loc].mSpeed); // ★ホーマット変更
          LCD.lcd_setCursor(0, 0);
          LCD.lcd_printStr(aTexts);

          LCD.lcd_setCursor(0, 1);
          for ( int i = 0; i < 8; i++)
          {
            if ( ((gLocTable[gTopIndex_Loc].mFunction >> i ) & 1) == 0)
            {
              aTexts[i] = '-';
            }
            else
            {
              aTexts[i] = '0' + i; // ★ convert function num. to ascii code
            }
          }
          //LCD.lcd_printStr(aTexts);

          if (validInt1)
            dispRollerSpeed();  // ★Add speed meter from roller/
          else
            LCD.lcd_printStr(aTexts);

        }
        else
        {
          /* ロコのパケットが流れてないとき */
          sprintf(aTexts, "Idle %3d", gCount_Idle);
          LCD.lcd_setCursor(0, 0);
          LCD.lcd_printStr(aTexts);
          LCD.lcd_setCursor(0, 1);
          LCD.lcd_printStr("  -DCC- ");

          /* アイドルパケットをリセット */
          gCount_Idle = 0;
        }

        break;


      case 1:
        passingSpeedMeter();
        break;
      
      case 2:
        //Accessory
        for( int i = 0; i < 16; i++)
          {
          LCD.lcd_setCursor(i & 0b111, i >> 3);
          if( ((gAccTable[0] >> i ) & 1) == 0)
          {
            LCD.lcd_printStr("/");
          }
          else
          {
            LCD.lcd_printStr("|");
          }
          }
          break;

          


      case 3:
        //Accessory
        /*for( int i = 0; i < 16; i++)
          {
        	LCD.lcd_setCursor(i & 0b111, i >> 3);
        	if( ((gAccTable[0] >> i ) & 1) == 0)
        	{
        		LCD.lcd_printStr("/");
        	}
        	else
        	{
        		LCD.lcd_printStr("|");
        	}
          }*/
        sprintf(aTexts, "%3d%s%3d%s", gAccLatestAddr[0], (gAccLatestDir[0] == 0) ? "/" : "|", gAccLatestAddr[1], (gAccLatestDir[1] == 0) ? "/" : "|");
        LCD.lcd_setCursor(0, 0);
        LCD.lcd_printStr(aTexts);

        sprintf(aTexts, "%3d%s%3d%s", gAccLatestAddr[2], (gAccLatestDir[2] == 0) ? "/" : "|", gAccLatestAddr[3], (gAccLatestDir[3] == 0) ? "/" : "|");
        LCD.lcd_setCursor(0, 1);
        LCD.lcd_printStr(aTexts);


        break;

      case 4:
        //Edc
        aVolt = ReadEdcVoltage();
        sprintf(aTexts, "%2d.%dV   ", aVolt / 10, aVolt % 10);
        LCD.lcd_setCursor(0, 0);
        LCD.lcd_printStr(aTexts);
        LCD.lcd_setCursor(0, 1);
        LCD.lcd_printStr("  -DCC- ");
        break;

      case 5:

        Dcc.getPulseWidth(&aMax0, &aMin0, &aMax1, &aMin1);

        if ( (aMax0 != 0) && (aMin0 != 0x0FF))
        {

          sprintf(aTexts, "|%3d/%2d", aMin1, aMax1);
          LCD.lcd_setCursor(0, 0);
          LCD.lcd_printStr(aTexts);
        }

        if ( (aMax1 != 0) && (aMin1 != 0x0FF))
        {
          sprintf(aTexts, "O%3d/%2d", aMin0, aMax0);
          LCD.lcd_setCursor(0, 1);
          LCD.lcd_printStr(aTexts);
        }
        break;

      case 6:

        sprintf(aTexts, "Pre%2d/%2d", gCount_PreMin, gCount_PreMax);
        LCD.lcd_setCursor(0, 0);
        LCD.lcd_printStr(aTexts);

        sprintf(aTexts, "Err%5d", gCount_Err);
        LCD.lcd_setCursor(0, 1);
        LCD.lcd_printStr(aTexts);
        break;
        
      case 7:
          

        if ( gTopIndex_Loc != 0xFF)
        {
          sprintf(aTexts, "DCC Pckt");
          LCD.lcd_setCursor(0, 0);
          LCD.lcd_printStr(aTexts);

          unsigned char i = 0;
          unsigned char dd;
          for (i = 0; i < message[0]; i++) // ★表示文字の転送
          {
            dd = message[i + 1] >> 4;
            if (dd < 10) aTexts[2 * i] = dd + '0'; else aTexts[2 * i] = dd + 'A' - 10;
            dd = message[i + 1] % 16;
            if (dd < 10) aTexts[2 * i + 1] = dd + '0'; else aTexts[2 * i + 1] = dd + 'A' - 10;
          }
          for (; i <= 4; i++)
          {
            aTexts[2 * i] = ' ';
            aTexts[2 * i + 1] = ' ';
          }
          aTexts[9] = 0; // ★ termination=NULL
          LCD.lcd_setCursor(0, 1);
          LCD.lcd_printStr(aTexts);
        }
        else
        {
          /* ロコのパケットが流れてないとき */
          sprintf(aTexts, "Idle %3d", gCount_Idle);
          LCD.lcd_setCursor(0, 0);
          LCD.lcd_printStr(aTexts);
          LCD.lcd_setCursor(0, 1);
          LCD.lcd_printStr("  -DCC- ");

          /* アイドルパケットをリセット */
          gCount_Idle = 0;
        }

        break;
        

    }
  }
}

void ClearTable()
{
  for ( int i = 0; i < MAX_LOCTABLE; i++)
  {
    gLocTable[i].mAddr = 0;
    gLocTable[i].mSpeed = 0;
    gLocTable[i].mDirection = 0;
    gLocTable[i].mFunction = 0;
  }
}

void DisplayFunctionBit(uint32_t inFunctionBits)
{

  for ( int i = 0; i < 29; i++)
  {
    if ( bitRead(inFunctionBits, i) == 0)
    {
      Serial.print(".");
    }
    else
    {
      Serial.print("O");
    }

  }
}

void DisplayAccBit(uint16_t inFunctionBits)
{

  for ( int i = 0; i < 16; i++)
  {
    if ( bitRead(inFunctionBits, i) == 0)
    {
      Serial.print(".");
    }
    else
    {
      Serial.print("O");
    }

  }
}

/* 全DCCメッセージを受信 */
void notifyDccMsg( DCC_MSG * Msg)
{
  uint8_t aErrorbyte = 0;
  uint16_t aLocoAddr = 0;
  uint16_t aAccAddr = 0;


  /* エラーチェック */
  for (uint8_t i = 0; i < Msg->Size; i++)
  {
    aErrorbyte = aErrorbyte ^ Msg->Data[i];
  }

  message[0] = Msg->Size;
  for (uint8_t i = 0; i < Msg->Size; i++)
  {
    message[i + 1] = Msg->Data[i];
  }


  if ( aErrorbyte != 0)
  {
    if ( gCount_Err < 65535)
    {
      gCount_Err++;
    }

    return;
  }
  else
  {
    gWatchMode = 1;
  }

  /* プリアンブル数計算 */
  if ( Msg->PreambleBits < gCount_PreMin)
  {
    gCount_PreMin = Msg->PreambleBits;
  }
  else if ( Msg->PreambleBits > gCount_PreMax)
  {
    gCount_PreMax = Msg->PreambleBits;
  }


  /* パケットチェック */
  switch (Msg->Data[0])
  {
    case 0x00:
      //Broadcast

      if ( Msg->Data[1] == 0x00)
      {
        gCount_Reset++;
      }
      else
      {
        /* その他のBroadcast処理 */
      }

      break;

    case 0xFF:
      //Idle packet
      gCount_Idle++;
      break;

    default:

      if ( Msg->Data[0] <= 127)
      {
        /* SHORTアドレスロコの操作 */
        aLocoAddr = Msg->Data[0];

        decodeLocoPacket(aLocoAddr, Msg->Data[1], Msg->Data[2]);


      }
      else if (( Msg->Data[0] >= 128) && ( Msg->Data[0] <= 191))
      {
        /* アクセサリ */
        aAccAddr = (((Msg->Data[0] & 0b111111) - 1) * 4) + ((7 - (Msg->Data[1] >> 4) & 0b111) << 8) +  (((Msg->Data[1] >> 1) & 0b11));


        if ( (Msg->Data[1] & 1) == 0)
        {
          gAccTable[ aAccAddr >> 4 ] = gAccTable[ aAccAddr >> 4 ] & (~(1 << (aAccAddr & 0xFFFF)) & 0xFFFF);


          if ( aAccAddr != gAccLastAddr)
          {
            gAccLatestAddr[3] = gAccLatestAddr[2];
            gAccLatestDir[3] = gAccLatestDir[2];

            gAccLatestAddr[2] = gAccLatestAddr[1];
            gAccLatestDir[2] = gAccLatestDir[1];

            gAccLatestAddr[1] = gAccLatestAddr[0];
            gAccLatestDir[1] = gAccLatestDir[0];

            gAccLatestAddr[0] = aAccAddr + 1;
            gAccLatestDir[0] = 0;
          }
          else
          {
            gAccLatestDir[0] = 0;
          }

          //uiPacketInfo.innerText = uiPacketInfo.innerText + ", direction is diverse.";
        }
        else
        {
          gAccTable[ aAccAddr >> 4 ] = gAccTable[ aAccAddr >> 4 ] | (1 << (aAccAddr & 0xFFFF)) ;
          //uiPacketInfo.innerText = uiPacketInfo.innerText + ", direction is straight.";

          if ( aAccAddr != gAccLastAddr)
          {
            gAccLatestAddr[3] = gAccLatestAddr[2];
            gAccLatestDir[3] = gAccLatestDir[2];

            gAccLatestAddr[2] = gAccLatestAddr[1];
            gAccLatestDir[2] = gAccLatestDir[1];

            gAccLatestAddr[1] = gAccLatestAddr[0];
            gAccLatestDir[1] = gAccLatestDir[0];

            gAccLatestAddr[0] = aAccAddr + 1;
            gAccLatestDir[0] = 1;
          }
          else
          {
            gAccLatestDir[0] = 1;
          }
        }

        gAccLastAddr = aAccAddr;


      }
      else if (( Msg->Data[0] >= 192) && ( Msg->Data[0] <= 231))
      {
        /* LONGアドレスロコの操作 */
        aLocoAddr = ((Msg->Data[0] - 192) << 8) + Msg->Data[1];

        decodeLocoPacket(aLocoAddr, Msg->Data[2], Msg->Data[3]);
      }
      else if (( Msg->Data[0] >= 232) && ( Msg->Data[0] <= 254))
      {
        /* 予約 */

      }



      break;

  }

}

void decodeLocoPacket(word inLocoAddr, uint8_t inPacket1, uint8_t inPacket2)
{
  uint8_t aSpeed;
  uint8_t aIndex = getLocAddrIndex(inLocoAddr);

  switch (inPacket1 >> 5)
  {
    case 0b000:
      break;

    case 0b001:

      switch (inPacket1 & 0b11111)
      {
        case 31:

          aSpeed = inPacket2 & 0b01111111;

          if ( aSpeed > 1)
          {
            aSpeed = aSpeed - 1;
          }

          /* リスト更新 */
          updateDccSpeed( inLocoAddr, aSpeed, (inPacket2 >> 7) & 1, 127 );
          break;
      }
      break;

    case 0b010:
      //REV

      aSpeed = inPacket1 & 0b11111;

      for (int i = 0; i < 29; i++)
      {
        if ( aSpeed == DCC_28SPEEDMAP[i])
        {
          /* リスト更新 */
          updateDccSpeed( inLocoAddr, i, 0, 29 );

          break;
        }
      }

      break;
    case 0b011:
      //FWD

      aSpeed = inPacket1 & 0b11111;

      for (int i = 0; i < 29; i++)
      {
        if ( aSpeed == DCC_28SPEEDMAP[i])
        {
          /* リスト更新 */
          updateDccSpeed( inLocoAddr, i, 1, 29 );

          break;
        }
      }

      break;

    case 0b100:
      bitWrite( gLocTable[aIndex].mFunction, 0, (inPacket1 >> 4) & 1);
      bitWrite( gLocTable[aIndex].mFunction, 1, (inPacket1 >> 0) & 1);
      bitWrite( gLocTable[aIndex].mFunction, 2, (inPacket1 >> 1) & 1);
      bitWrite( gLocTable[aIndex].mFunction, 3, (inPacket1 >> 2) & 1);
      bitWrite( gLocTable[aIndex].mFunction, 4, (inPacket1 >> 3) & 1);
      break;

    case 0b101:

      switch ((inPacket1 >> 4) & 1)
      {
        case 1:
          bitWrite( gLocTable[aIndex].mFunction, 5, (inPacket1 >> 0) & 1);
          bitWrite( gLocTable[aIndex].mFunction, 6, (inPacket1 >> 1) & 1);
          bitWrite( gLocTable[aIndex].mFunction, 7, (inPacket1 >> 2) & 1);
          bitWrite( gLocTable[aIndex].mFunction, 8, (inPacket1 >> 3) & 1);
          break;
        case 0:
          bitWrite( gLocTable[aIndex].mFunction, 9, (inPacket1 >> 0) & 1);
          bitWrite( gLocTable[aIndex].mFunction, 10, (inPacket1 >> 1) & 1);
          bitWrite( gLocTable[aIndex].mFunction, 11, (inPacket1 >> 2) & 1);
          bitWrite( gLocTable[aIndex].mFunction, 12, (inPacket1 >> 3) & 1);
          break;
      }
      break;

    case 0b110:


      switch (inPacket1 & 0b11111)
      {
        case 30:
          bitWrite( gLocTable[aIndex].mFunction, 13, (inPacket2 >> 0) & 1);
          bitWrite( gLocTable[aIndex].mFunction, 14, (inPacket2 >> 1) & 1);
          bitWrite( gLocTable[aIndex].mFunction, 15, (inPacket2 >> 2) & 1);
          bitWrite( gLocTable[aIndex].mFunction, 16, (inPacket2 >> 3) & 1);
          bitWrite( gLocTable[aIndex].mFunction, 17, (inPacket2 >> 4) & 1);
          bitWrite( gLocTable[aIndex].mFunction, 18, (inPacket2 >> 5) & 1);
          bitWrite( gLocTable[aIndex].mFunction, 19, (inPacket2 >> 6) & 1);
          bitWrite( gLocTable[aIndex].mFunction, 20, (inPacket2 >> 7) & 1);
          break;

        case 31:
          bitWrite( gLocTable[aIndex].mFunction, 21, (inPacket2 >> 0) & 1);
          bitWrite( gLocTable[aIndex].mFunction, 22, (inPacket2 >> 1) & 1);
          bitWrite( gLocTable[aIndex].mFunction, 23, (inPacket2 >> 2) & 1);
          bitWrite( gLocTable[aIndex].mFunction, 24, (inPacket2 >> 3) & 1);
          bitWrite( gLocTable[aIndex].mFunction, 25, (inPacket2 >> 4) & 1);
          bitWrite( gLocTable[aIndex].mFunction, 26, (inPacket2 >> 5) & 1);
          bitWrite( gLocTable[aIndex].mFunction, 27, (inPacket2 >> 6) & 1);
          bitWrite( gLocTable[aIndex].mFunction, 28, (inPacket2 >> 7) & 1);
          break;
      }
  }



}

uint16_t getLocAddrIndex(uint16_t inAddr)
{
  uint16_t aIndex = 0xFFFF;

  for ( int i = 0; i < MAX_LOCTABLE; i++)
  {
    if ( (gLocTable[i].mAddr == inAddr) || (gLocTable[i].mAddr == 0) )
    {

      gLocTable[i].mAddr = inAddr;

      aIndex = i;

      break;
    }
  }

  return aIndex;
}

void updateDccSpeed( uint16_t inAddr, uint8_t inSpeed, uint8_t inDir, uint8_t inSpeedSteps )
{

  uint16_t aSpeed = 0, hSpeed = 0;

  for ( int i = 0; i < MAX_LOCTABLE; i++)
  {
    if ( (gLocTable[i].mAddr == inAddr) || (gLocTable[i].mAddr == 0) )
    {

      gLocTable[i].mAddr = inAddr;

      if ( inSpeed >= 1)
      {
        aSpeed = ((uint16_t)inSpeed * 100) / (uint16_t)(inSpeedSteps - 1); // ★　スピードステップ-1で計算する
        hSpeed = inSpeed;
      }
      else
      {
        hSpeed = aSpeed = 0;
      }


      if ( (aSpeed != gLocTable[i].mSpeed) || (gLocTable[i].mDirection != inDir))
      {
        gLocTable[i].mSpeed = aSpeed;
        gLocTable[i].mSpeedhex = hSpeed; // ★1
        gLocTable[i].mDirection = inDir;

        gTopIndex_Loc = i;

      }


      /* for文終了 */
      break;
    }


  }
}


uint16_t ReadEdcVoltage()
{

  //電圧換算
  // 1k / 11k  y=((x*11*5)/1/1024)
  uint16_t aVolt = analogRead(A2);

  //Limit
  if ( aVolt > 922)
  {
    //30Vで打ち止め
    aVolt = 922;
  }

  aVolt = aVolt >> 2;

  aVolt = (aVolt * 301) >> 7;

  if ( aVolt > 255)
  {
    //UCに入るサイズにリミット(25.5V)
    aVolt = 255;
  }

  return aVolt;

}
