/*
  DSstick  throttle based on Keyboard Joystick
  For the Arduino Pro Micro.
  
  Copyright(C) 2019- Desktop Station
  
  DSair2:
  https://desktopstation.net/wiki/doku.php/dsair2_ukeng
  
  DSair2 WebApp keyboard function mapping specification:
  https://desktopstation.net/wiki/doku.php/dsair2_keyboard


  fujigaya2 190827 for DCC Cheap Controller

*/

#include "Keyboard.h"

//#define BTN_STOP	7
#define BTN_DIR		A3
#define BTN_F0		6
#define BTN_F1		7
#define BTN_F2		8
#define BTN_F3		11
#define BTN_F4    12
//#define ENC_A		2
//#define ENC_B		3
#define SPEED_REF A2

#define WAIT_KEY	333
#define WAIT_KEY_SPD	200


//byte valenc;
short val;

//Task Schedule
unsigned long gPreviousL1 = 0; // 250ms interval(Packet Task)


void setup()
{
	//PIN MODE
	//pinMode(BTN_STOP, INPUT);
	pinMode(BTN_DIR, INPUT);
	pinMode(BTN_F0, INPUT);
	pinMode(BTN_F1, INPUT);
	pinMode(BTN_F2, INPUT);
	pinMode(BTN_F3, INPUT);
  pinMode(BTN_F4, INPUT);
	//pinMode(ENC_A, INPUT);
	//pinMode(ENC_B, INPUT);
	
	//Internal PULL UP
	//digitalWrite(BTN_STOP, HIGH);
	digitalWrite(BTN_DIR, HIGH);
	digitalWrite(BTN_F0, HIGH);
	digitalWrite(BTN_F1, HIGH);
	digitalWrite(BTN_F2, HIGH);
	digitalWrite(BTN_F3, HIGH);
  digitalWrite(BTN_F4, HIGH);
	//digitalWrite(ENC_A, HIGH);
	//digitalWrite(ENC_B, HIGH);
	
	//Reset task
	gPreviousL1 = millis();
	
	//valenc = 0;
	val = 0;
	
	// initialize control over the keyboard:
	Keyboard.begin();
}


void loop() 
{
	// valenc = (valenc << 2) & B00001100;
	// valenc += (digitalRead(ENC_A) << 1) + (digitalRead(ENC_B));

	/*
	L 0010 1011 1101 0100
	R 0001 0111 1110 1000
	*/
/*
	switch(valenc)
	{
		//�����v���
		case B00000010 : //fallthrough
		case B00001011 : //fallthrough
		case B00001101 : //fallthrough
		case B00000100 :
			if(val > -255)
			{
				val--;
			}
			
		break;

		//���v���
		case B00000001 : //fallthrough 
		case B00000111 : //fallthrough 
		case B00001110 : //fallthrough 
		case B00001000 : 
			if(val < 255)
			{
				val++;
			}
			

		break;
	}
*/	
	if( (millis() - gPreviousL1) >= 250)
	{
    val = analogRead(SPEED_REF);
    int val_select = val / 128;
    switch(val_select)
    {
      case 0 : Keyboard.print("b");delay(WAIT_KEY_SPD);break;
      case 1 : Keyboard.print("n");delay(WAIT_KEY_SPD);break;
      case 2 : Keyboard.print("m");delay(WAIT_KEY_SPD);break;
      case 3 : Keyboard.print("g");delay(WAIT_KEY_SPD);break;
      case 4 : Keyboard.print("h");delay(WAIT_KEY_SPD);break;
      case 5 : Keyboard.print("j");delay(WAIT_KEY_SPD);break;
      case 6 : Keyboard.print("t");delay(WAIT_KEY_SPD);break;
      case 7 : Keyboard.print("y");delay(WAIT_KEY_SPD);break;
      default : Keyboard.print("b");delay(WAIT_KEY_SPD);break;      
    }
/*
		//Reset task
		gPreviousL1 = millis();
		
		if( val < -4)
		{
			Keyboard.print("d");
			delay(WAIT_KEY_SPD);
			val = 0;
		}
		else if( val < -2)
		{
			Keyboard.print("s");
			delay(WAIT_KEY_SPD);
			val = 0;
		}
		
		if( val > 4)
		{
			Keyboard.print("c");
			delay(WAIT_KEY_SPD);
			val = 0;
		}
		else if( val > 2)
		{
			Keyboard.print("x");
			delay(WAIT_KEY_SPD);
			val = 0;
		}
		else
		{
			val = 0;
		}
*/
	}	
/*	
	if( digitalRead(BTN_STOP) == 0 )
	{
		Keyboard.print("q");
		delay(WAIT_KEY);
	}
*/
	
	if( digitalRead(BTN_DIR) == 0 )
	{
		Keyboard.print("z");
		delay(WAIT_KEY);
	}
	
	if( digitalRead(BTN_F0) == 0 )
	{
		Keyboard.print("0");
		delay(WAIT_KEY);
	}
	if( digitalRead(BTN_F1) == 0 )
	{
		Keyboard.print("1");
		delay(WAIT_KEY);
	}
	
	if( digitalRead(BTN_F2) == 0 )
	{
		Keyboard.print("2");
		delay(WAIT_KEY);
	}
	
	if( digitalRead(BTN_F3) == 0 )
	{
		Keyboard.print("3");
		delay(WAIT_KEY);
	}

  if( digitalRead(BTN_F4) == 0 )
  {
    Keyboard.print("4");
    delay(WAIT_KEY);
  }
}
